#ifdef GL_ES
precision mediump float;

varying	vec3 lightVector, halfVector, lightVector2;
varying vec2 vTexCoord;

vec4 fragColor;
#else
in vec3 lightVector, halfVector, lightVector2;
in vec2 vTexCoord;

out vec4 fragColor;
#endif
uniform sampler2D normalTex;
uniform sampler2D colorTex;
uniform sampler2D ambTex;
uniform float brightness;
uniform float fade;

void main()
{
#ifdef GL_ES
	vec4 bumpSample = texture2D(normalTex, vTexCoord.st);
    vec4 tColor = texture2D(colorTex, vTexCoord.st);
#else
    vec4 bumpSample = texture(normalTex, vTexCoord.st);
    vec4 tColor = texture(colorTex, vTexCoord.st);
#endif
	vec3 bump = (bumpSample.xyz * 2.0 - 1.0);

	float light1 = max(0.0, dot(bump, normalize(lightVector)));
#ifdef GL_ES
	float light2 = max(0.0, dot(bump, normalize(lightVector2))) * texture2D(ambTex, vTexCoord.st).r;
#else
    float light2 = max(0.0, dot(bump, normalize(lightVector2))) * texture(ambTex, vTexCoord.st).r;
#endif
	float lambert = sqrt(light1 * light1 + light2 * light2);
	vec3 diffuse = tColor.rgb * lambert;
	float specular = pow(max(0.0, dot(bump, normalize(halfVector))), 128.0 * bumpSample.w);

	fragColor = vec4((diffuse + vec3(specular)) * tColor.a, tColor.a) * fade;
#ifdef GL_ES
    gl_FragColor = fragColor;
#endif
}
